<?php
session_start();
ini_set('display_errors',1);
ini_set('display_startup_errors',1);
error_reporting(E_ALL);

$cfg = include __DIR__ . '/config.php';
require_once __DIR__ . '/functions.php';
$pdo = db_connect($cfg);

$action = $_POST['action'] ?? '';
header('Content-Type: application/json');

function send_json($data){
    echo json_encode($data, JSON_PRETTY_PRINT);
    exit;
}

// Helper to safely post to LG-Pay
function safe_post($url,$params){
    $res = http_post($url,$params);
    if(isset($res['error'])) return ['status'=>0,'msg'=>'Curl Error: '.$res['error']];
    if(isset($res['raw'])) return ['status'=>0,'msg'=>'Raw Response: '.$res['raw']];
    return $res;
}

// ================= Check Balance =================
if($action=='balance'){
    $app = $_POST['app_id'] ?? '';
    $secret = $_POST['secret'] ?? '';
    if(!$app || !$secret) send_json(['status'=>0,'msg'=>'App ID or Secret missing']);
    $_SESSION['last_app_id'] = $app;

    $params = ['app_id'=>$app,'time'=>time()];
    $params['sign'] = lg_sign($params,$secret);
    $res = safe_post($cfg['endpoints']['balance'],$params);
    send_json($res);
}

// ================= Create Withdrawal =================
if($action=='create'){
    $app = $_POST['app_id'] ?? '';
    $secret = $_POST['secret'] ?? '';
    if(!$app || !$secret) send_json(['status'=>0,'msg'=>'App ID or Secret missing']);
    $_SESSION['last_app_id'] = $app;

    $amt = floatval($_POST['amount'] ?? 0);
    $money = intval(round($amt*100));
    $order = $_POST['order_sn'] ?: 'wd_'.date('YmdHis');

    $params = [
        'app_id'=>$app,
        'order_sn'=>$order,
        'currency'=>$_POST['currency'] ?? 'INR',
        'money'=>$money,
        'notify_url'=>$_POST['notify_url'] ?? '',
        'name'=>$_POST['name'] ?? '',
        'bank_name'=>$_POST['bank_name'] ?? '',
        'card_number'=>$_POST['card_number'] ?? '',
        'addon1'=>$_POST['addon1'] ?? ''
    ];
    $params['sign'] = lg_sign($params,$secret);
    $res = safe_post($cfg['endpoints']['create'],$params);

    $_SESSION['last_order_sn'] = $order;

    $stmt = $pdo->prepare("INSERT INTO lgpay_withdraws(order_sn,app_id,money,currency,response) VALUES(?,?,?,?,?)");
    $stmt->execute([$order,$app,$money,$params['currency'],json_encode($res)]);

    send_json($res);
}

// ================= Query Withdrawal =================
if($action=='query'){
    $app = $_POST['app_id'] ?? '';
    $secret = $_POST['secret'] ?? '';
    $order = $_POST['order_sn'] ?: ($_SESSION['last_order_sn'] ?? '');
    if(!$app || !$secret || !$order) send_json(['status'=>0,'msg'=>'Missing parameters']);

    $params = ['app_id'=>$app,'order_sn'=>$order];
    $params['sign'] = lg_sign($params,$secret);
    $res = safe_post($cfg['endpoints']['query'],$params);

    send_json($res);
}

send_json(['status'=>0,'msg'=>'Invalid action']);
