<?php
function db_connect($cfg){
    $dsn = sprintf('mysql:host=%s;dbname=%s;charset=%s',
        $cfg['db']['host'],$cfg['db']['name'],$cfg['db']['charset']);
    return new PDO($dsn,$cfg['db']['user'],$cfg['db']['pass'],[
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
    ]);
}

function http_post($url,$data){
    $ch = curl_init($url);
    curl_setopt($ch,CURLOPT_RETURNTRANSFER,true);
    curl_setopt($ch,CURLOPT_POST,true);
    curl_setopt($ch,CURLOPT_POSTFIELDS,http_build_query($data));
    curl_setopt($ch,CURLOPT_TIMEOUT,30);
    curl_setopt($ch,CURLOPT_SSL_VERIFYPEER,false);
    $res = curl_exec($ch);
    $err = curl_error($ch);
    curl_close($ch);
    if($res===false){
        return ['status'=>0,'msg'=>'Curl Error: '.$err];
    }
    $json = json_decode($res,true);
    return $json ? $json : ['status'=>0,'msg'=>'Invalid JSON','raw'=>$res];
}

/**
 * LG-Pay Signature (official)
 */
function lg_sign(array $params, $secret){
    // Remove empty values
    foreach($params as $k=>$v){
        if($v === '' || $v === null){
            unset($params[$k]);
        }
    }

    // Sort keys ASCII ascending
    ksort($params);

    // Build URL query string
    $string = http_build_query($params);
    $string = urldecode($string);

    // Append secret key
    $string .= "&key=".$secret;

    // MD5 uppercase
    return strtoupper(md5($string));
}

/**
 * Verify callback signature
 */
function verify_lg_sign(array $params, $secret){
    if(empty($params['sign'])) return false;
    $sign = $params['sign'];
    unset($params['sign']);
    return lg_sign($params,$secret) === strtoupper($sign);
}

/**
 * Write to log
 */
function write_log($path,$text){
    file_put_contents($path,"[".date('Y-m-d H:i:s')."] ".$text."\n",FILE_APPEND);
}

/**
 * Generate unique order_sn
 */
function make_order_sn(){
    return 'WD'.date('YmdHis').rand(1000,9999);
}

/**
 * Query balance
 */
function query_balance($app_id,$secret,$endpoint){
    $time = time();
    $params = [
        'app_id'=>$app_id,
        'time'=>$time
    ];
    $params['sign'] = lg_sign($params,$secret);
    return http_post($endpoint,$params);
}

/**
 * Create withdrawal
 */
function create_withdrawal($data,$secret,$endpoint){
    if(empty($data['order_sn'])) $data['order_sn'] = make_order_sn();
    $data['money'] = intval(round(floatval($data['amount'])*100));
    unset($data['amount']);
    $data['sign'] = lg_sign($data,$secret);
    return http_post($endpoint,$data);
}

/**
 * Query withdrawal
 */
function query_withdrawal($app_id,$secret,$order_sn,$endpoint){
    $params = [
        'app_id'=>$app_id,
        'order_sn'=>$order_sn
    ];
    $params['sign'] = lg_sign($params,$secret);
    return http_post($endpoint,$params);
}
?>
