<?php
// LG-Pay callback handler
require_once __DIR__.'/config.php';
require_once __DIR__.'/functions.php';

$pdo = db_connect(include __DIR__.'/config.php');

// Read POST data
$data = $_POST;
$raw_post = json_encode($data, JSON_PRETTY_PRINT);

// Basic validation
if(empty($data['order_sn']) || empty($data['status']) || empty($data['sign'])){
    echo "ok"; // LG-Pay retry 4 times if not ok
    exit;
}

// Fetch secret key from DB if you store per app_id, else set default
$app_id = $data['app_id'] ?? '';
$secret = $cfg['default_secret'] ?? ''; // set your default secret

// Verify signature
if(!verify_lg_sign($data, $secret)){
    file_put_contents($cfg['callback_log'], "[".date('Y-m-d H:i:s')."] Sign verification failed: ".json_encode($data)."\n", FILE_APPEND);
    echo "ok"; exit;
}

// Update DB
$order_sn = $data['order_sn'];
$status = intval($data['status']); // 1=success,0=fail
$msg = $data['msg'] ?? '';
$money = intval($data['money'] ?? 0);

$stmt = $pdo->prepare("UPDATE lgpay_withdraws SET callback_status=?, callback_data=? WHERE order_sn=?");
$stmt->execute([$status ? 1 : 2, $raw_post, $order_sn]);

// Log callback
file_put_contents($cfg['callback_log'], "[".date('Y-m-d H:i:s')."] Callback received: ".json_encode($data)."\n", FILE_APPEND);

// Respond ok to LG-Pay
echo "ok";
exit;
