<?php
session_start();
$cfg = include __DIR__ . '/config.php';
require_once __DIR__ . '/functions.php';
$pdo = db_connect($cfg);
$lastApp = $_SESSION['last_app_id'] ?? '';
$lastOrder = $_SESSION['last_order_sn'] ?? '';
?>
<!doctype html>
<html>
<head>
<meta charset="utf-8">
<title>LGPay Advanced Panel</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/css/bootstrap.min.css" rel="stylesheet">
<style>
body{background:#f5f5f5;padding:20px}
.card{margin-bottom:20px;border-radius:12px;box-shadow:0 4px 12px rgba(0,0,0,0.08)}
.card-header{font-weight:bold;font-size:1.2em}
pre{background:#272c34;color:#f8f8f2;padding:12px;border-radius:8px;overflow-x:auto}
</style>
</head>
<body>
<div class="container">
<h2 class="mb-4">🏦 LGPay Advanced Payout Panel</h2>
<p class="text-muted">Domain: <?php echo htmlspecialchars($_SERVER['HTTP_HOST']); ?> — Callback log: <?php echo htmlspecialchars($cfg['callback_log']); ?></p>

<div class="row">
    <!-- Check Balance -->
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">Check Balance</div>
            <div class="card-body">
                <form id="form-balance">
                    <div class="row mb-2">
                        <div class="col-md-4"><input name="app_id" class="form-control" placeholder="App ID" value="<?php echo htmlspecialchars($lastApp); ?>"></div>
                        <div class="col-md-4"><input name="secret" type="text" class="form-control" placeholder="Secret Key"></div>
                        <div class="col-md-4"><button class="btn btn-primary w-100">Check Balance</button></div>
                    </div>
                </form>
                <pre id="balance-result">Result will appear here...</pre>
            </div>
        </div>
    </div>

    <!-- Create Withdrawal -->
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">Create Withdrawal</div>
            <div class="card-body">
                <form id="form-withdraw">
                    <div class="row mb-2">
                        <div class="col-md-3"><input name="app_id" class="form-control" placeholder="App ID" value="<?php echo htmlspecialchars($lastApp); ?>"></div>
                        <div class="col-md-3"><input name="secret" type="text" class="form-control" placeholder="Secret Key"></div>
                        <div class="col-md-2"><input name="amount" class="form-control" placeholder="Amount (INR)"></div>
                        <div class="col-md-4"><input name="order_sn" class="form-control" placeholder="Order SN (optional)"></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-md-3"><input name="name" class="form-control" placeholder="Recipient Name"></div>
                        <div class="col-md-3"><input name="bank_name" class="form-control" placeholder="Bank Name"></div>
                        <div class="col-md-3"><input name="card_number" class="form-control" placeholder="Account / Card Number"></div>
                        <div class="col-md-3"><input name="addon1" class="form-control" placeholder="IFSC / addon1"></div>
                    </div>
                    <div class="row mb-2">
                        <div class="col-md-3"><input name="currency" class="form-control" value="INR"></div>
                        <div class="col-md-9"><input name="notify_url" class="form-control" value="<?php echo 'https://' . $_SERVER['HTTP_HOST'] . '/callback.php'; ?>"></div>
                    </div>
                    <button class="btn btn-success w-100">Create Withdrawal</button>
                </form>
                <pre id="withdraw-result">Result will appear here...</pre>
            </div>
        </div>
    </div>

    <!-- Query Withdrawal -->
    <div class="col-md-12">
        <div class="card">
            <div class="card-header">Query Withdrawal</div>
            <div class="card-body">
                <form id="form-query">
                    <div class="row mb-2">
                        <div class="col-md-4"><input name="app_id" class="form-control" placeholder="App ID" value="<?php echo htmlspecialchars($lastApp); ?>"></div>
                        <div class="col-md-4"><input name="secret" type="text" class="form-control" placeholder="Secret Key"></div>
                        <div class="col-md-4"><input name="order_sn" class="form-control" placeholder="Order SN (optional)" value="<?php echo htmlspecialchars($lastOrder); ?>"></div>
                    </div>
                    <button class="btn btn-warning w-100">Query Withdrawal</button>
                </form>
                <pre id="query-result">Result will appear here...</pre>
            </div>
        </div>
    </div>
</div>

</div>
<script src="https://code.jquery.com/jquery-3.7.1.min.js"></script>
<script>
function ajaxForm(formId,resultId,action){
    $(formId).on('submit',function(e){
        e.preventDefault();
        let formData = $(this).serialize() + '&action='+action;
        $(resultId).text("Processing...");
        $.post('process.php',formData,function(res){
            try{
                if(typeof res === 'string'){
                    res = JSON.parse(res.replace(/^\s+|\s+$/g,'')); // trim whitespace
                }
            } catch(e){
                $(resultId).text("JSON Parse Error:\n"+res);
                return;
            }
            $(resultId).text(JSON.stringify(res,null,4));
        }).fail(function(xhr){
            $(resultId).text("Request Failed: "+xhr.statusText);
        });
    });
}
ajaxForm('#form-balance','#balance-result','balance');
ajaxForm('#form-withdraw','#withdraw-result','create');
ajaxForm('#form-query','#query-result','query');
</script>
</body>
</html>
